function test_suite = testMrdivide %#ok<STOUT>
initTestSuite;

function testZeroDividedByReal %#ok<*DEFNU>
x = polysym(0);
y = polysym(rand);
z = x/y;
assertTrue(z.Value=='0');

function testZeroDividedByChar
x = polysym(0);
y = polysym('y');
z = x/y;
assertTrue(z.Value=='0');

function testZeroDividedByZero
x = polysym(0);
f = @() x/0;
assertExceptionThrown(f,'polysym:mrdivide:DivideByZero')

function testCharDividedByZero
x = polysym('x');
f = @() x/0;
assertExceptionThrown(f,'polysym:mrdivide:DivideByZero')

function testCharDividedByInteger
x = polysym('x');
z = x/5;
assertEqual(z.Value,'x/5');

function testCharDividedByReal
x = polysym('x');
y = polysym(pi);
z = x/y;
assertEqual(z.Value,['x/',y.Value]);

function testRealDividedByChar
x = polysym(pi);
y = polysym('y');
z = x/y;
assertEqual(z.Value,[x.Value,'/y']);

function testScalarDividedByVector
x = polysym('x');
f = @() x/(1:3);
assertExceptionThrown(f,'polysym:mrdivide:NotScalar')

function testVectorDividedByVector
x = polysym({'x','y'});
y = polysym({'u','w'});
f = @() x/y;
assertExceptionThrown(f,'polysym:mrdivide:NotScalar')

function testDivDiv
% NOTE: This result is undesirable.
x = polysym('x');
y = polysym('4/y');
z = x/y;
assertEqual(z.Value,'x/4/y');
